/*
 * File: UnitConverter.java
 * =================================================
 * A program to convert between kilograms and pounds.
 */

import acm.program.*;
import acm.gui.*;
import java.awt.event.*;
import javax.swing.*;

public class UnitConverter extends Program {
	/* How many pounds are in one kilogram. */
	private static final double POUNDS_PER_KILOGRAM = 2.20462262;
	
	/* The two input fields for the number of kilograms or pounds. */
	private DoubleField kgsField, lbsField;
	
	public void init() {
		/* Use a table layout to organize the interactors. */
		setLayout(new TableLayout(2, 3));
		
		/* Set up the kilograms entry. */
		add(new JLabel("Kilograms: "));
		kgsField = new DoubleField();
		kgsField.addActionListener(this);
		kgsField.setActionCommand("To Pounds");
		add(kgsField);
		add(new JButton("To Pounds"));
		
		/* Set up the pounds entry. */
		add(new JLabel("Pounds: "));
		lbsField = new DoubleField();
		lbsField.addActionListener(this);
		lbsField.setActionCommand("To Kilograms");
		add(lbsField);
		add(new JButton("To Kilograms"));
		
		addActionListeners();
	}
	
	/**
	 * On receipt of a message, do the appropriate conversion.
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("To Pounds")) {
			lbsField.setValue(kgsField.getValue() * POUNDS_PER_KILOGRAM);
		} else if (e.getActionCommand().equals("To Kilograms")) {
			kgsField.setValue(lbsField.getValue() / POUNDS_PER_KILOGRAM);
		}
	}
}
